package kom.itbeankit.nw.ethernet;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.net.*;

import kom.itbeankit.common.vcr.*;
import symantec.itools.awt.*;

import kom.itbeankit.common.itbeanframe.*;
import kom.itbeankit.common.vcr.ControlButtonPanel;
import symantec.itools.awt.SplitterPanel;
import kom.itbeankit.nw.ethernet.Host;
import kom.itbeankit.common.message.*;
import kom.itbeankit.nw.ethernet.*;

import symantec.itools.awt.HorizontalSlider;
public class ItBeanEthernetFrame extends Frame
{
	// Used for addNotify check.
	boolean fComponentsAdjusted = false;
	//{{DECLARE_CONTROLS
	kom.itbeankit.common.vcr.ControlButtonPanel vcr;
	java.awt.Panel panel;
	java.awt.Panel mainPanel;
	kom.itbeankit.nw.ethernet.Hubap ethernet;
	java.awt.Panel parameterPanel;
	java.awt.Label scenarioLabel;
	java.awt.Choice scenarioChoice;
	java.awt.Label protocolLabel;
	java.awt.Choice protocolChoice;
	java.awt.Label numberLabel;
	java.awt.Choice numberChoice;
	java.awt.Checkbox padFielsCheckbox;
	java.awt.Label speedLabel;
	symantec.itools.awt.HorizontalSlider speedSlider;
	java.awt.Button clearTextButton;
	java.awt.Button resetEffButton;
	java.awt.Panel textPanel;
	kom.itbeankit.common.message.Messenger messenger;
	//}}
	private String defaultDir;
	private String aboutMessage;
	private URL enteredURL;
	private ItBeanFrameListener listener;
	//kom.itbeankit.common.vcr.ControlButtonPanel vcrControlButtonPanel1;
    protected int actualComplexityLevel = 1;

	//{{DECLARE_MENUS
	java.awt.MenuBar mainMenuBar;
	java.awt.Menu FileMenu;
	java.awt.MenuItem itBeanNew;
	java.awt.MenuItem itBeanOpen;
	java.awt.MenuItem itBeanSave;
	java.awt.MenuItem itBeanSaveAs;
	java.awt.MenuItem itBeanExit;
	java.awt.Menu OptionsMenu;
	java.awt.Menu languageMenu;
	java.awt.CheckboxMenuItem language1MenuItem;
	java.awt.CheckboxMenuItem language2MenuItem;
	java.awt.CheckboxMenuItem language3MenuItem;
	java.awt.Menu ExplanationMenu;
	java.awt.CheckboxMenuItem checkboxMenuItem1;
	java.awt.CheckboxMenuItem checkboxMenuItem2;
	java.awt.CheckboxMenuItem checkboxMenuItem3;
	java.awt.Menu helpMenu;
	java.awt.MenuItem itBeanGuidedTour;
	java.awt.MenuItem itBeanAbout;
	//}}
    public CheckboxMenuItemGroup languages;
	SplitterPanel splitterPanel1;


	public ItBeanEthernetFrame()
	{
	    super();
		//{{INIT_CONTROLS
		setLayout(new BorderLayout(0,0));
		setVisible(false);
		setSize(629,526);
		setFont(new Font("Dialog", Font.PLAIN, 12));
		setForeground(new Color(0));
		setBackground(new Color(16777215));
		vcr = new kom.itbeankit.common.vcr.ControlButtonPanel();
		vcr.setNumberOfComplexityLevels(3);
		vcr.setTimerDelay(1000);
		vcr.setLayout(new GridLayout(1,1,0,0));
		vcr.setBounds(0,503,629,23);
		add("South", vcr);
		panel = new java.awt.Panel();
		GridBagLayout gridBagLayout;
		gridBagLayout = new GridBagLayout();
		panel.setLayout(gridBagLayout);
		panel.setBounds(0,0,629,503);
		add("Center", panel);
		mainPanel = new java.awt.Panel();
		mainPanel.setLayout(new BorderLayout(0,0));
		mainPanel.setBounds(0,0,630,340);
		GridBagConstraints gbc;
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(mainPanel, gbc);
		panel.add(mainPanel);
		ethernet = new kom.itbeankit.nw.ethernet.Hubap();
		ethernet.setLayout(new BorderLayout(0,0));
		ethernet.setBounds(0,0,630,340);
		mainPanel.add("Center", ethernet);
		parameterPanel = new java.awt.Panel();
		gridBagLayout = new GridBagLayout();
		parameterPanel.setLayout(gridBagLayout);
		parameterPanel.setBounds(398,340,232,163);
		parameterPanel.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.gridx = 1;
		gbc.gridy = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(parameterPanel, gbc);
		panel.add(parameterPanel);
		parameterPanel.setCursor(new Cursor(Cursor.HAND_CURSOR));
		scenarioLabel = new java.awt.Label("Scenario");
		scenarioLabel.setBounds(5,1,87,23);
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(scenarioLabel, gbc);
		parameterPanel.add(scenarioLabel);
		scenarioChoice = new java.awt.Choice();
		scenarioChoice.addItem("None");
		scenarioChoice.addItem("Normal Operation");
		scenarioChoice.addItem("Collision");
		try {
			scenarioChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		scenarioChoice.setBounds(102,2,125,21);
		gbc = new GridBagConstraints();
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(scenarioChoice, gbc);
		parameterPanel.add(scenarioChoice);
		protocolLabel = new java.awt.Label("Protocol");
		protocolLabel.setBounds(5,24,87,23);
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(protocolLabel, gbc);
		parameterPanel.add(protocolLabel);
		protocolChoice = new java.awt.Choice();
		protocolChoice.addItem("1-persistent CSMA");
		protocolChoice.addItem("nonpersistent CSMA");
		try {
			protocolChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		protocolChoice.setBounds(102,25,125,21);
		gbc = new GridBagConstraints();
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(protocolChoice, gbc);
		parameterPanel.add(protocolChoice);
		numberLabel = new java.awt.Label("Number of Hosts");
		numberLabel.setBounds(5,47,87,23);
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(numberLabel, gbc);
		parameterPanel.add(numberLabel);
		numberChoice = new java.awt.Choice();
		numberChoice.addItem("6");
		numberChoice.addItem("3");
		
		try {
			numberChoice.select(0);
		}
		catch (IllegalArgumentException e) { }
		numberChoice.setBounds(102,48,125,21);
		gbc = new GridBagConstraints();
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(numberChoice, gbc);
		parameterPanel.add(numberChoice);
		padFielsCheckbox = new java.awt.Checkbox("Use pad field for short frames");
		padFielsCheckbox.setBounds(5,70,222,23);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(padFielsCheckbox, gbc);
		parameterPanel.add(padFielsCheckbox);
		speedLabel = new java.awt.Label("Animation Speed");
		speedLabel.setBounds(5,104,92,23);
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.anchor = GridBagConstraints.WEST;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,5,0,0);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(speedLabel, gbc);
		parameterPanel.add(speedLabel);
		speedSlider = new symantec.itools.awt.HorizontalSlider();
		try {
			speedSlider.setMaxValue(1500);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			speedSlider.setMinValue(100);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			speedSlider.setValue(1300);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			speedSlider.setTickFreq(200);
		}
		catch(java.beans.PropertyVetoException e) { }
		try {
			speedSlider.setTickStyle(symantec.itools.awt.HorizontalSlider.TICK_BOTTOM);
		}
		catch(java.beans.PropertyVetoException e) { }
		speedSlider.setBounds(102,93,125,40);
		gbc = new GridBagConstraints();
		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.fill = GridBagConstraints.HORIZONTAL;
		gbc.insets = new Insets(0,5,5,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(speedSlider, gbc);
		parameterPanel.add(speedSlider);
		clearTextButton = new java.awt.Button();
		clearTextButton.setLabel("clear text area");
		clearTextButton.setBounds(5,138,87,23);
		clearTextButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(clearTextButton, gbc);
		parameterPanel.add(clearTextButton);
		resetEffButton = new java.awt.Button();
		resetEffButton.setLabel("reset efficiency");
		resetEffButton.setBounds(117,138,95,23);
		resetEffButton.setBackground(new Color(12632256));
		gbc = new GridBagConstraints();
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.NONE;
		gbc.insets = new Insets(0,5,0,5);
		((GridBagLayout)parameterPanel.getLayout()).setConstraints(resetEffButton, gbc);
		parameterPanel.add(resetEffButton);
		textPanel = new java.awt.Panel();
		textPanel.setLayout(new BorderLayout(0,0));
		textPanel.setBounds(0,340,398,163);
		gbc = new GridBagConstraints();
		gbc.gridx = 0;
		gbc.gridy = 1;
		gbc.weightx = 1.0;
		gbc.weighty = 1.0;
		gbc.fill = GridBagConstraints.BOTH;
		gbc.insets = new Insets(0,0,0,0);
		((GridBagLayout)panel.getLayout()).setConstraints(textPanel, gbc);
		panel.add(textPanel);
		messenger = new kom.itbeankit.common.message.Messenger();
		messenger.setBounds(0,0,398,163);
		textPanel.add("Center", messenger);
		messenger.setCursor(new Cursor(Cursor.TEXT_CURSOR));
		setTitle("ItBean Ethernet Frame");
		//}}

        vcr.setEnabled(ControlButtonPanel.BACKWARD_BUTTON,false);
        vcr.setEnabled(ControlButtonPanel.HIDE_BUTTON,false);

		//{{INIT_MENUS
		mainMenuBar = new java.awt.MenuBar();
		FileMenu = new java.awt.Menu("  File  ");
		itBeanNew = new java.awt.MenuItem("New");
		FileMenu.add(itBeanNew);
		itBeanOpen = new java.awt.MenuItem("Open");
		FileMenu.add(itBeanOpen);
		itBeanSave = new java.awt.MenuItem("Save");
		FileMenu.add(itBeanSave);
		itBeanSaveAs = new java.awt.MenuItem("Save as ...");
		FileMenu.add(itBeanSaveAs);
		FileMenu.addSeparator();
		itBeanExit = new java.awt.MenuItem("Exit");
		FileMenu.add(itBeanExit);
		mainMenuBar.add(FileMenu);
		OptionsMenu = new java.awt.Menu("  Options  ");
		languageMenu = new java.awt.Menu("Languages");
		language1MenuItem = new java.awt.CheckboxMenuItem("Englisch");
		language1MenuItem.setState(false);
		languageMenu.add(language1MenuItem);
		language2MenuItem = new java.awt.CheckboxMenuItem("Deutsch");
		language2MenuItem.setState(false);
		languageMenu.add(language2MenuItem);
		language3MenuItem = new java.awt.CheckboxMenuItem("Spanisch");
		language3MenuItem.setState(false);
		languageMenu.add(language3MenuItem);
		OptionsMenu.add(languageMenu);
		ExplanationMenu = new java.awt.Menu("Explanation");
		checkboxMenuItem1 = new java.awt.CheckboxMenuItem("Log");
		checkboxMenuItem1.setState(true);
		ExplanationMenu.add(checkboxMenuItem1);
		checkboxMenuItem2 = new java.awt.CheckboxMenuItem("Errors");
		checkboxMenuItem2.setState(false);
		ExplanationMenu.add(checkboxMenuItem2);
		checkboxMenuItem3 = new java.awt.CheckboxMenuItem("Debug");
		checkboxMenuItem3.setState(false);
		ExplanationMenu.add(checkboxMenuItem3);
		OptionsMenu.add(ExplanationMenu);
		mainMenuBar.add(OptionsMenu);
		helpMenu = new java.awt.Menu("  Help  ");
		itBeanGuidedTour = new java.awt.MenuItem("Guided Tour");
		helpMenu.add(itBeanGuidedTour);
		itBeanAbout = new java.awt.MenuItem("About");
		helpMenu.add(itBeanAbout);
		mainMenuBar.add(helpMenu);
		setMenuBar(mainMenuBar);
		//$$ mainMenuBar.move(0,0);
		//}} INIT_MENUS

        this.languages = new CheckboxMenuItemGroup();
        languages.add(language1MenuItem);
       	languages.add(language2MenuItem);
       	languages.add(language3MenuItem);


		splitterPanel1 = new symantec.itools.awt.SplitterPanel();
		splitterPanel1.setBounds(0,0,640,417);
		add("Center",splitterPanel1);

		splitterPanel1.setGapSizes(9);
		splitterPanel1.split(splitterPanel1.SPLIT_HORIZONTAL);
        splitterPanel1.getBottomPanel().split(splitterPanel1.SPLIT_VERTICAL);
        splitterPanel1.getBottomRightPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getBottomRightPanel().add("Center",parameterPanel);
        splitterPanel1.getTopPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getTopPanel().add("Center",mainPanel);
        splitterPanel1.getBottomLeftPanel().setLayout(new BorderLayout(0,0));
        splitterPanel1.getBottomLeftPanel().add("Center",messenger);
	    remove(panel);

        //complx level 1
        ethernet.setEnabled(false);
        padFielsCheckbox.setEnabled(false);
        numberLabel.setEnabled(false);
        numberChoice.setEnabled(false);
        messenger.setText("Please choose a scenario and your desired"+"\n"+
                          "protocol and press PLAY or STEP to see the"+"\n"+
                          "scenario continuous or step-by-step respectively.");

		//{{REGISTER_LISTENERS USING ANONYMUS INNER CLASS
		ItBeanWindowAdapter anitBeanWindowAdapter = new ItBeanWindowAdapter();
		addWindowListener(anitBeanWindowAdapter);
		ItBeanFrameAction litBeanFrameAction = new ItBeanFrameAction();
		this.itBeanOpen.addActionListener(litBeanFrameAction);
		this.itBeanAbout.addActionListener(litBeanFrameAction);
		this.itBeanSave.addActionListener(litBeanFrameAction);
		this.itBeanSaveAs.addActionListener(litBeanFrameAction);
		this.itBeanExit.addActionListener(litBeanFrameAction);
		this.itBeanGuidedTour.addActionListener(litBeanFrameAction);
		this.itBeanNew.addActionListener(litBeanFrameAction);
		this.vcr.addActionListener(litBeanFrameAction);
        ItBeanFrameItemAdapter itemAdapter = new ItBeanFrameItemAdapter();
		this.language1MenuItem.addItemListener(itemAdapter);
		this.language2MenuItem.addItemListener(itemAdapter);
		this.language3MenuItem.addItemListener(itemAdapter);
		this.checkboxMenuItem1.addItemListener(itemAdapter);
		this.checkboxMenuItem2.addItemListener(itemAdapter);
		this.checkboxMenuItem3.addItemListener(itemAdapter);
		SymClk lSymClk = new SymClk();
		vcr.addClkListener(lSymClk);
		SymMessage lSymMessage = new SymMessage();
		ethernet.addMessageListener(lSymMessage);
		SymAction lSymAction = new SymAction();
		clearTextButton.addActionListener(lSymAction);
		resetEffButton.addActionListener(lSymAction);
		SymItem lSymItem = new SymItem();
		padFielsCheckbox.addItemListener(lSymItem);
		protocolChoice.addItemListener(lSymItem);
		numberChoice.addItemListener(lSymItem);
		scenarioChoice.addItemListener(lSymItem);
		speedSlider.addActionListener(lSymAction);
		vcr.addActionListener(lSymAction);
		//}}
	}

    public void paint(Graphics g){
        super.paint(g);
        messenger.setBounds(splitterPanel1.getBottomLeftPanel().getBounds());
        parameterPanel.setBounds(0,0,
                            splitterPanel1.getBottomRightPanel().getSize().width,
                            splitterPanel1.getBottomRightPanel().getSize().height);
    }

	public ItBeanEthernetFrame(String title)
	{
		this();
		setTitle(title);
	}

    /**
    This method sets the complexitylevel
    */
    public void setNumberOfLevels(int numberoflevels) {
    this.vcr.setNumberOfComplexityLevels(numberoflevels);
    }


    /**
    This method gets the complexitylevel
    */
    public int getNumberOfLevels() {
        return this.vcr.getNumberOfComplexityLevels();
    }

    /**
     * Shows or hides the component depending on the boolean flag b.
     * @param b  if true, show the component; otherwise, hide the component.
     * @see java.awt.Component#isVisible
     */
    public void setVisible(boolean b)
	{
		if(b)
		{
			setLocation(50, 50);
		}
		super.setVisible(b);
	}
	public void addNotify()
	{
		// Record the size of the window prior to calling parents addNotify.
		Dimension d = getSize();

		super.addNotify();

		if (fComponentsAdjusted)
			return;

		// Adjust components according to the insets
		setSize(insets().left + insets().right + d.width, insets().top + insets().bottom + d.height);
		Component components[] = getComponents();
		for (int i = 0; i < components.length; i++)
		{
			Point p = components[i].getLocation();
			p.translate(insets().left, insets().top);
			components[i].setLocation(p);
		}
		fComponentsAdjusted = true;
	}

    /*********************************************************************************
   * Called whenever the part throws an exception.
   * @param exception java.lang.Throwable
   ********************************************************************************/
  private void handleException(Throwable exception) {
    /* Uncomment the following lines to print uncaught exceptions to stdout */
    System.out.println("UNCAUGHT EXCEPTION in ItBeanFrame");
    exception.printStackTrace(System.out);
  }

  /**
   * Return the ControlButtonPanel1 property value.
   * @return common.itbeanframe.ControlButtonPanel
   */
  private ControlButtonPanel getControlButtonPanel1() {
    if (vcr == null) {
      try {
	    vcr = new ControlButtonPanel();
	    vcr.setName("ControlButtonPanel1");
	    vcr.setBounds(20, 375, 355, 35);
      } catch (java.lang.Throwable e) {
	    handleException(e);
      };
    }
    return vcr;
  }

 // Methods to get/set the DelayTime of a vcrControlButtonPanel event
    public int getStepDelayTime() {
        return vcr.getTimerDelay();
    }

    public void setStepDelayTime(int newDelayTime) {
        vcr.setTimerDelay(newDelayTime);
    }

   /**
	Inner class itBeanWindowAdapter implements the WindowEvent action.
	*/
	class ItBeanWindowAdapter extends java.awt.event.WindowAdapter
	{
		public void windowClosing(java.awt.event.WindowEvent event)
		{
			Object object = event.getSource();
			if (object == ItBeanEthernetFrame.this)
				ItBeanFrame_hide();
		}
	}

	void ItBeanFrame_hide()
	{
		setVisible(false);	// hide the Frame
	}

	class ItBeanFrameAction implements java.awt.event.ActionListener
	{
		//This method receives the ActionEvents 
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == itBeanNew)
			    itBeanNew_Action(event);
			else if (object == itBeanOpen)
				itBeanOpen_Action(event);
			else if (object == itBeanAbout)
				itBeanAbout_Action(event);
			else if (object == itBeanExit)
				itBeanExit_Action(event);
			else if (object == itBeanSave)
			    itBeanSave_Action(event);
			else if (object == itBeanSaveAs)
			    itBeanSaveAs_Action(event);
			else if (object == itBeanGuidedTour)
			    itBeanGuidedTour_Action(event);
		  //new line added by Alexander Kempf888
			else if (object == vcr)
			    vcrControlButtonPanel1_Action(event);
		}
	}


	/**
	This inner class implements the ItemListener that listens on changed menu items.
	*/
	class ItBeanFrameItemAdapter implements java.awt.event.ItemListener {

    /**
    Will be called if a CheckboxMenuItem was changed.
	@param the occurred itemEvent
	*/
	public void itemStateChanged(java.awt.event.ItemEvent e) {
	  Object source = e.getSource();
	    if ((source == checkboxMenuItem1) || (source == checkboxMenuItem2) || (source == checkboxMenuItem3))
	      explanationChanged(e);
	    if ((source == language1MenuItem) || (source == language2MenuItem) || (source == language3MenuItem))
	      languageChanged(e);
	    }
	}

	/** Called if the explanation was changed in options menu */
	void explanationChanged(ItemEvent e) {
	    CheckboxMenuItem source = (CheckboxMenuItem)e.getSource();
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.EXPLANATION_CHANGED, source.getActionCommand()));
	}

	/** Called if the language was changed in options menu */
	void languageChanged(ItemEvent e) {
	  CheckboxMenuItem source = (CheckboxMenuItem)e.getSource();
      fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.LANGUAGE_CHANGED, source.getActionCommand() ));
    }

	/** Called if the new item was selected. Forwards the event. */
	void itBeanNew_Action(ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.NEW_FILE));
	}

	/** Called if the save item was selected. SAVE the event. */
	void itBeanSave_Action(java.awt.event.ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.SAVE));
	}

	/** Called if the save_as item was selected. Opens a file dialog and
	forwards the event if a valid file was choiced. */
	void itBeanSaveAs_Action(java.awt.event.ActionEvent event) {
        FileDialog dialog = new FileDialog(this, "Save As", FileDialog.SAVE);
        if (this.defaultDir != null) dialog.setDirectory(this.defaultDir);
        dialog.show();
		// now FileDialog returned
		if (dialog.getFile() == null) return;
		this.defaultDir = dialog.getDirectory();
		fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.SAVE_AS, dialog.getDirectory()+dialog.getFile()));
	}

	/** Called if the about item was selected. Opens the about dialog and forwards the event. */
	void itBeanAbout_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from About Create and show as modal
		//kom.itbeankit.common.message.AboutDialog ad = new kom.itbeankit.common.message.AboutDialog(this, true);
		//ad.setUserLabel(this.aboutMessage);
		//ad.setVisible(true);
	    //fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.ABOUT));
		//}}
	}

	/** Called if the GuidedTour item was selected. Forwards the event. */
	void itBeanGuidedTour_Action(ActionEvent event) {
	    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.GUIDED_TOUR));
	}

	/** Called if the exit item was selected. A Yes/No-dialog will be opened
	and the event will be forwarded if the dialog returns true. */
	void itBeanExit_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Exit Create and show as modal
	fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.EXIT));
		//}}
	}

	/** Called if the open_URL item was selected. A URLDialog will be opened.
	If it returns a valid URL, an ItBeanFrameEvent.OPEN event will be fired */
	void itBeanOpen_Action(java.awt.event.ActionEvent event)
	{
		//{{CONNECTION
		// Action from Open... Show the URLDialog
		URLDialog dialog = new URLDialog(this, "Enter URL");
		if (this.enteredURL != null ) dialog.setURL(this.enteredURL);
		dialog.setSize(300,200);
		dialog.show();
		if (dialog.getURL() != null) { // if a valid URL has been entered
		    this.enteredURL = dialog.getURL();
		    fireFrameEvent(new ItBeanFrameEvent(this, ItBeanFrameEvent.OPEN_URL));
		}
		//}}
	}

	/**
	This method is invoked if the vcrControlButtonPanel1 sources an ActionEvent.
	It invokes the fireFrameEvent()-method with a newly created ItBeanFramEvent.
	This method was added by Alexander Kempf
	*/

	void vcrControlButtonPanel1_Action(java.awt.event.ActionEvent event) {
	  /*  if ("play".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.PLAY,event.getActionCommand()));
	    else if ("stop".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.STOP,event.getActionCommand()));
	    else if ("forwards".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.FORWARDS,event.getActionCommand()));
	    else if ("backwards".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.BACKWARDS,event.getActionCommand()));
	    else if ("pause".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.PAUSE,event.getActionCommand()));
	    else if ("hide".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.HIDE,event.getActionCommand()));
        else if ("levelDown".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.LEVEL_DOWN,event.getActionCommand()));
        else if ("levelUp".equals(event.getActionCommand()))
	        fireFrameEvent(new ItBeanFrameEvent(event.getSource(),ItBeanFrameEvent.LEVEL_UP,event.getActionCommand()));
    */
        if ("stop".equals(event.getActionCommand())){
            ethernet.reset();
            scenarioChoice.select(0);
        }
	}

	/**
	This method fires an ItBeanFrameEvent by calling the methods of the
	registrated ItBeanFrameListeners.
	*/
	private void fireFrameEvent(ItBeanFrameEvent e) {
	    if (this.listener == null) return;
	    int id = e.getID();
	    switch (id) {
	        case ItBeanFrameEvent.NEW_FILE: { this.listener.newFile(e); break; }
        	case ItBeanFrameEvent.STOP: { this.listener.stop(e); break; }
        	case ItBeanFrameEvent.PLAY: { this.listener.play(e); break; }
        	case ItBeanFrameEvent.PAUSE: { this.listener.pause(e); break; }
        	case ItBeanFrameEvent.FORWARDS: { this.listener.forwards(e); break; }
           	case ItBeanFrameEvent.TOBEGIN: { this.listener.toBegin(e); break; }
	        case ItBeanFrameEvent.BACKWARDS: { this.listener.backwards(e); break; }
	        case ItBeanFrameEvent.HIDE: { this.listener.hide(e); break; }
	        case ItBeanFrameEvent.OPEN_URL: { this.listener.openURL(e); break; }
	        case ItBeanFrameEvent.SAVE: { this.listener.save(e); break; }
	        case ItBeanFrameEvent.SAVE_AS: { this.listener.saveAs(e); break; }
	        case ItBeanFrameEvent.EXIT: { this.listener.exit(e); break; }
	        case ItBeanFrameEvent.LEVEL_DOWN: { this.listener.levelDown(e); break; }
	        case ItBeanFrameEvent.LEVEL_UP: { this.listener.levelUp(e); break; }
	        case ItBeanFrameEvent.LANGUAGE_CHANGED: { this.listener.languageChanged(e); break; }
            case ItBeanFrameEvent.EXPLANATION_CHANGED: { this.listener.explanationChanged(e); break; }
	        case ItBeanFrameEvent.GUIDED_TOUR: { this.listener.guidedTour(e); break; }
            case ItBeanFrameEvent.ABOUT: { this.listener.about(e); break; }
        }
    }

    /**
    This method is used to registrate the ItBeanFrameListener.
    Only one listener is allowed (unicast).
    @param the listener
    @exception java.util.TooManyListenersException
    */
    public synchronized void addItBeanFrameListener(ItBeanFrameListener l) throws java.util.TooManyListenersException{
        if ((this.listener != null) && (this.listener != l)) {
            throw new java.util.TooManyListenersException("Already a listener registrated");
        }
        if (l != null) this.listener = l;
    }

    /**
    This method is used to deregistrate the ItBeanFrameListener.
    @param the listener
    */
    public synchronized void removeItBeanFrameListener(ItBeanFrameListener l) {
        if (this.listener == l) this.listener = null;
    }

    /**
    This method returns the top subpanel, which is normally
    used to visualize the itBeans information (visualization output).
    @return the top  panel
    */
    public Component getTopComponent() {
    Component p = (Component) this.splitterPanel1.getTopPanel();
    //p.setSize(300,300);
    return p;
    }

    public void setTopComponent(Component c) {
    //c.setSize(300,300);
     splitterPanel1.getTopPanel().add(c);
    }

    /**
    This method returns the bottom right subpanel, which is normally
    used to place some components to parametrize the bean (e.g. Choices, Checkboxes)
    @return the bottom right panel
    */
    public Component getBottomRightComponent() {
      return (Component)this.splitterPanel1.getBottomRightPanel();
    }

    public void setBottomRightComponent(Component c) {
      splitterPanel1.getBottomRightPanel().add(c);
    }

    /**
    This method returns the bottom left subpanel, which is normally
    used to place some components to parametrize the bean (e.g. Choices, Checkboxes)
    @return the bottom right panel
    */
    public Component getBottomLeftComponent() {
      return (Component)this.splitterPanel1.getBottomRightPanel();
    }

    public void setBottomLeftComponent(Component c) {
      splitterPanel1.getBottomRightPanel().add(c);
    }


    /**
    This method appends text to the text area at top right, which
    is normally used to print log, help and explanation texts.
    @param the text to append
    */
    public void appendText(String text) {
      this.messenger.append(text);
    }

    /**
    This method returns the URL if an URL was entered after having
    selected the openURL menu item.
    @return the entered URL
    */
    public URL getEnteredURL() {
        return this.enteredURL;
    }

    /**
    This method sets the URL that is default if an URLDialog is opened.
    Normally the parent applet sets the CodeBase- or the DocumentBase-URL.
    @param the default URL
    */
    public void setEnteredULR(URL defaultURL) {
        this.enteredURL = defaultURL;
    }

    /**
    This method sets the default directory for the file dialog of the SaveAs-menu-item.
    @param the default directory
    */
    public void setDefaultDir(String dir) {
        this.defaultDir = dir;
    }

    /**
    This method sets the bean specified about-message that is printed out in the
    AboutDialog after heving selected about item.
    @param the about message
    */
    public void setAboutMessage(String message) {
        this.aboutMessage = message;
    }


	static public void main(String args[])
	{
		(new ItBeanEthernetFrame()).setVisible(true);
	}







	class SymClk implements kom.itbeankit.common.vcr.ClkListener
	{
		public void clkReceived(kom.itbeankit.common.vcr.ClkEvent event)
		{
			Object object = event.getSource();
			if (object == vcr)
				vcr_clkReceived(event);
		}
	}

	void vcr_clkReceived(kom.itbeankit.common.vcr.ClkEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// clkReceived...
		{
			ethernet.clkReceived(event);
		}
		//}}
	}

	class SymMessage implements kom.itbeankit.common.message.MessageListener
	{
		public void deliverMessage(kom.itbeankit.common.message.MessageEvent event)
		{
			Object object = event.getSource();
			if (object == ethernet)
				ethernet1_deliverMessage(event);
		}
	}

	void ethernet1_deliverMessage(kom.itbeankit.common.message.MessageEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// deliverMessage...
		{
			messenger.deliverMessage(event);
		}
		//}}
	}

	class SymAction implements java.awt.event.ActionListener
	{
		public void actionPerformed(java.awt.event.ActionEvent event)
		{
			Object object = event.getSource();
			if (object == clearTextButton)
				clearTextButton_ActionPerformed(event);
			else if (object == resetEffButton)
				resetEffButton_ActionPerformed(event);
			else if (object == speedSlider)
				speedSlider_actionPerformed(event);
			else if (object == vcr)
				vcr_actionPerformed(event);
		}
	}

	void clearTextButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// Clear the text for Messenger
		{
			messenger.setText("");
		}
		//}}
	}

	void resetEffButton_ActionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// resetDataSize
		{
			ethernet.resetDataSize();
		}
		//}}
	}


	class SymItem implements java.awt.event.ItemListener
	{
		public void itemStateChanged(java.awt.event.ItemEvent event)
		{
			Object object = event.getSource();
			if (object == padFielsCheckbox)
				padFielsCheckbox_ItemStateChanged(event);
			else if (object == protocolChoice)
				protocolChoice_ItemStateChanged(event);
			else if (object == numberChoice)
				numberChoice_ItemStateChanged(event);
			else if (object == scenarioChoice)
				scenarioChoice_ItemStateChanged(event);
		}
	}

	void padFielsCheckbox_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// setUsePadField... Is Checkbox On?
		{
			ethernet.setUsePadField(padFielsCheckbox.getState());
		}
		//}}
	}

	void protocolChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// setAlgorithm... Get the current item text
		{
			int index = protocolChoice.getSelectedIndex();
			if(index==0)
			    ethernet.setAlgorithm("kom.itbeankit.nw.ethernet.OnePersistentAlgorithm");
			else if(index==1)
			    ethernet.setAlgorithm("kom.itbeankit.nw.ethernet.NonPersistentAlgorithm");
		}
		//}}
	}

	void numberChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// setNumOfHosts... Get the current item as an int
		{
			try {
				ethernet.setNumOfHosts(Integer.parseInt(numberChoice.getSelectedItem()));
			}
			catch(Exception e) { }
		}
		//}}
	}



	void scenarioChoice_ItemStateChanged(java.awt.event.ItemEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// setScenario... Get the current item index
		{
		    //if any other senario than NONE, numOfHost should be set to 8 
			if(scenarioChoice.getSelectedIndex()!=0){
			    numberChoice.select(0);
			    ethernet.setNumOfHosts(6);
			}
			ethernet.setScenario(scenarioChoice.getSelectedIndex());
		}
		//}}
	}



	void speedSlider_actionPerformed(java.awt.event.ActionEvent event)
	{
		// to do: code goes here.
			 
		//{{CONNECTION
		// setTimerDelay... Get the current value of the HorizontalSlider
		{
			vcr.setTimerDelay(3000 - speedSlider.getValue());
		}
		//}}
	}

	void vcr_actionPerformed(java.awt.event.ActionEvent event)
	{
        if ("levelDown".equals(event.getActionCommand())){
            setComplexityLevel(actualComplexityLevel-1);
        }
        else if ("levelUp".equals(event.getActionCommand())){        
            setComplexityLevel(actualComplexityLevel+1);
        }
	}
	
    public void setComplexityLevel(int l){
        actualComplexityLevel = l;
        ethernet.reset();
        switch(l){
            case 1:
                ethernet.setEnabled(false);
                padFielsCheckbox.setEnabled(false);
                numberLabel.setEnabled(false);
                numberChoice.setEnabled(false);
        		scenarioChoice.remove("Broadcast");
        		scenarioChoice.remove("Short Frame Problem");
        		try {
        			scenarioChoice.select(0);
        		}
        		catch (IllegalArgumentException e) { }
			    ethernet.setScenario(0);
            break;
            case 2:
                ethernet.setEnabled(false);
                padFielsCheckbox.setEnabled(true);
                numberLabel.setEnabled(false);
                numberChoice.setEnabled(false);
        		//add items only when there are not added before
        		if(scenarioChoice.getItemCount()<4){
            		scenarioChoice.remove("Broadcast");
            		scenarioChoice.remove("Short Frame Problem");
            	}
        		try {
        			scenarioChoice.select(0);
        		}
        		catch (IllegalArgumentException e) { }
			    ethernet.setScenario(0);
        		
            break;
            case 3:
                ethernet.setEnabled(true);
                padFielsCheckbox.setEnabled(true);
                numberLabel.setEnabled(true);
                numberChoice.setEnabled(true);
        		try {
        			scenarioChoice.select(0);
        		}
        		catch (IllegalArgumentException e) { }
			    ethernet.setScenario(0);
		        messenger.deliverMessage(new MessageEvent(this, 
		                                MessageEvent.DISPLAY_TYPE_DIALOG,
		                                MessageEvent.MSG_TYPE_INFO,
		                                "Level 3",
		                                "In this level you can click "+
		                                "on each host to define its function. "+
		                                "Using this option you can build your "+
		                                "own scenarios."));
            break;
            default:
        }
    }
    
    public int getComplexityLevel(){
        return actualComplexityLevel;
    }
    
}
